{{$DEFINE DEBUG}

program patchdos;
{

Patches a DOS boot sector (floppy or hard disk) to work on a PCjr with
more than 128K of RAM installed.  For an explanation of why this is
necessary, consult the included file "howpatch.txt".

This program is interative; there are no command-line arguments.

This program attempts to be as flexible as possible by not forcing the
patch to reside in a specific place, checks the boot sector for optimal
conditions, and aborts if something looks fishy.  Should be completely
safe, but with all software, YMMV, and I cannot be held responsible if
this program destroys your DOS boot sector.

20130407, trixter@oldskool.org
}

const
  JMPSHORT=$EB;
  JMPDIRECT=$E9;
  NOOP=$90;
  patchsize=16;
  patch:array[0..patchsize-1] of byte=(
  $00,                  {DB 00          (so prior string will terminate)}
  $1e,                  {PUSH DS}
  $31,$c0,              {XOR AX,AX}
  $8e,$d8,              {MOV DS,AX}
  $a1,$15,$04,          {MOV AX,[0415]}
  $a3,$13,$04,          {MOV [0413],AX}
  $1f,                  {POP DS}
  $e9,$00,$00           {JMP 0000       (will be fixed as patch runs)}
  );

var
  buf:array[0..512-1] of byte;
  idx:word;
  str:string;
  asciiPos,asciiLastPos:word;
  asciiLen,asciiLastLen:byte;

  oldJMP,newJMP:integer;
  si:shortint;
  i:integer;
  drive:byte;
  status:byte;

Function ReadKeyChar:Char; Assembler;
Asm
  xor ah,ah
  int 16h
  cmp al,0
  jne @endit
  mov al,ah
@endit:
end;

Function hex(l:longint):string;
const
  HexNybble:array[0..15] of char='0123456789ABCDEF';
Var
  s:string;
Begin
  s:='';
  If l=0
    Then s:='0'
    Else While l<>0 Do Begin
      s:=hexNybble[(l And $f)]+s;
      l:=l ShR 4;
    End;
  {while byte(s[0])<8 do s:='0'+s;} {pad to 4 characters}
  hex:=s;
End;

procedure fatal(s:string);
begin
  writeln('A fatal error has been encountered:');
  writeln(s);
  halt(1);
end;

begin
  writeln(#13#10'PATCHDOS patches a DOS boot sector for use with a PCjr.');
  writeln('Patching is necessary only if DOS does not boot (try before running this).');
  writeln('Please read HOWPATCH.TXT for an explanation of what this program does.');
  write('This program is interactive.  Continue? (Y/N) ');
  if upcase(readkeychar) <> 'Y' then halt(1);

  {ask user for drive letter}
  write(#13#10'Drive to patch? (A: or B: floppy, C: or later hard drive) ' );
  readln(str);
  drive:=ord(upcase(str[1]))-65;
  if drive>1 then drive:=drive+80-2;

  {read boot sector}
  asm
    {reset disk system}
    mov ah,0
    mov dl,drive
    int 13h

    {read first sector}
    mov ah,02
    mov al,1
    mov ch,0
    mov cl,1
    mov dh,0
    mov dl,drive
    push ds
    pop es
    mov bx,offset buf
    int 13h
    lahf
    and ah,00000001b
    mov status,ah
  end;
  if status<>0 then fatal('Boot sector read was not successful');

  {search for JMP at beginning and record abs loc where it initially goes}
  case buf[0] of
    JMPSHORT:if buf[2]<>NOOP
      then fatal('Short jump left no space for patching')
      else oldJMP:=buf[1] + 2;
    JMPDIRECT:if buf[3]<>NOOP
      then fatal('Direct jump left no space for patching')
      else oldJMP:=(buf[1] OR (buf[2] SHL 8)) + 3;
  else
    fatal('First opcode is not a JMP');
  end;

  {search for largest ASCII we can use to store patch in}
  asciiLen:=0; asciiLastLen:=0; str:='';
  for idx:={3e} $100 to 511-2 {55AA} do begin
    case char(buf[idx]) of
      #32..#127:begin
        if asciiLen=0 then asciiPos:=idx;
        inc(asciiLen);
        {str:=str+char(buf[idx]);}
      end;
    else
      begin
        if asciiLen>asciiLastLen then begin
          asciiLastLen:=asciiLen;
          asciiLastPos:=asciiPos;
        end;
        asciiLen:=0;
        {str:=''}
      end;
    end; {case}
  end;
  if asciiLastLen<16 then fatal('Couldn''t find an ASCII string large enough for the patch');
  str[0]:=chr(asciiLastLen);
  move(buf[asciiLastPos],str[1],asciiLastLen);
  writeln('Found a string we can use:');
  writeln('"',str,'"');
  {$IFNDEF DEBUG}
  writeln('String will be truncated to store our patch, looking like this:');
  dec(byte(str[0]),patchsize);
  writeln('"',str,'"');
  {$ENDIF}

  {insert patch into ASCII}
  {$IFDEF DEBUG}
  asciiPos:=asciiLastPos;
  {$ELSE}
  asciiPos:=asciiLastPos+asciiLastLen-patchsize;
  {$ENDIF}
  move(patch,buf[asciiPos],patchsize);

  {alter patch's JMP to go to original JMP}
  newJMP:=oldJMP-(asciiPOS+patchsize-3);
  {code a direct jump no matter how long -- I am not an assembler!}
  buf[asciiPOS+patchsize-3]:=JMPDIRECT;
  buf[asciiPOS+patchsize-2]:=lo(newJMP-3);
  buf[asciiPOS+patchsize-1]:=hi(newJMP-3);

  {patch initial jump to go to our code}
  newJMP:=asciiPOS+1; {+1 to skip over DB 00}
  buf[0]:=JMPDIRECT;
  buf[1]:=lo(newJMP-3);
  buf[2]:=hi(newJMP-3);

  {write boot sector to disk after user confirmation}
  write('Ready to write boot sector.  Continue? (Y/N) ');
  if upcase(readkeychar) <> 'Y' then halt(1);
  asm
    {reset disk system}
    mov ah,0
    mov dl,drive
    int 13h

    {write first sector}
    mov ah,03
    mov al,1
    mov ch,0
    mov cl,1
    mov dh,0
    mov dl,drive
    push ds
    pop es
    mov bx,offset buf
    {$IFNDEF DEBUG}
    int 13h
    {$ENDIF}
    lahf
    and ah,00000001b
    mov status,ah
  end;

  if status<>0
    then fatal('Boot sector write was not successful')
    else writeln(#13#10'Boot sector written.  Ensure the first line of CONFIG.SYS is "STACKS=0,0".');
end.
